"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var React = __importStar(require("react"));
var i18n_1 = require("../i18n");
var ValidationErrorSpecialFormatPrefix = '@@react-admin@@';
var ValidationError = function (props) {
    var error = props.error;
    var errorMessage = error;
    var translate = (0, i18n_1.useTranslate)();
    // react-hook-form expects errors to be plain strings but our validators can return objects
    // that have message and args.
    // To avoid double translation for users that validate with a schema instead of our validators
    // we use a special format for our validators errors.
    // The useInput hook handle the special formatting
    if (typeof error === 'string' &&
        error.startsWith(ValidationErrorSpecialFormatPrefix)) {
        errorMessage = JSON.parse(error.substring(ValidationErrorSpecialFormatPrefix.length));
    }
    if (errorMessage.message) {
        var _a = errorMessage, message = _a.message, args = _a.args;
        return React.createElement(React.Fragment, null, translate(message, __assign({ _: message }, args)));
    }
    return React.createElement(React.Fragment, null, translate(errorMessage, { _: errorMessage }));
};
exports.default = ValidationError;
//# sourceMappingURL=ValidationError.js.map