import { BaseSyntheticEvent } from 'react';
import { FieldValues, SubmitHandler, UseFormProps } from 'react-hook-form';
import { RaRecord } from '../types';
import { SaveHandler } from '../controller';
import { ValidateForm } from './getSimpleValidationResolver';
/**
 * Wrapper around react-hook-form's useForm
 *
 * This hook adds the following features to react-hook-form's useForm:
 *
 * - form initialization based on RecordContext
 * - validation based on a validate function
 * - sanitization of empty values
 * - notification on invalid form
 * - stop form submission event propagation
 */
export declare const useAugmentedForm: <RecordType = any>(props: UseAugmentedFormProps<RecordType>) => {
    form: import("react-hook-form").UseFormReturn<any, any, undefined>;
    handleSubmit: (values: any, event: any) => Promise<void>;
    formHandleSubmit: (event: BaseSyntheticEvent) => void;
};
export type UseAugmentedFormProps<RecordType = any> = UseFormOwnProps<RecordType> & Omit<UseFormProps, 'onSubmit'> & {
    validate?: ValidateForm;
};
export interface UseFormOwnProps<RecordType = any> {
    defaultValues?: any;
    formRootPathname?: string;
    record?: Partial<RaRecord>;
    onSubmit?: SubmitHandler<FieldValues> | SaveHandler<RecordType>;
    sanitizeEmptyValues?: boolean;
    disableInvalidFormNotification?: boolean;
}
//# sourceMappingURL=useAugmentedForm.d.ts.map