"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useNotifyIsFormInvalid = void 0;
var react_1 = require("react");
var react_hook_form_1 = require("react-hook-form");
var notification_1 = require("../notification");
/**
 * This hook display an error message on submit in Form and SaveButton.
 *
 * We can't do the form validity check in the form submit handler
 * as the form state may not have been updated yet when onSubmit validation mode is enabled
 * or when the form hasn't been touched at all.
 */
var useNotifyIsFormInvalid = function (control, enabled) {
    if (enabled === void 0) { enabled = true; }
    var _a = (0, react_hook_form_1.useFormState)(control ? { control: control } : undefined), submitCount = _a.submitCount, errors = _a.errors;
    var submitCountRef = (0, react_1.useRef)(submitCount);
    var notify = (0, notification_1.useNotify)();
    (0, react_1.useEffect)(function () {
        var _a, _b;
        // Checking the submit count allows us to only display the notification after users
        // tried to submit
        if (submitCount > submitCountRef.current && enabled) {
            submitCountRef.current = submitCount;
            if (Object.keys(errors).length > 0) {
                var serverError = typeof ((_b = (_a = errors.root) === null || _a === void 0 ? void 0 : _a.serverError) === null || _b === void 0 ? void 0 : _b.message) === 'string'
                    ? errors.root.serverError.message
                    : undefined;
                notify(serverError || 'ra.message.invalid_form', {
                    type: 'error',
                });
            }
        }
    }, [errors, submitCount, notify, enabled]);
};
exports.useNotifyIsFormInvalid = useNotifyIsFormInvalid;
//# sourceMappingURL=useNotifyIsFormInvalid.js.map