"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useUnique = void 0;
var merge_1 = __importDefault(require("lodash/merge"));
var core_1 = require("../core");
var dataProvider_1 = require("../dataProvider");
var i18n_1 = require("../i18n");
var react_1 = require("react");
var set_1 = __importDefault(require("lodash/set"));
var util_1 = require("../util");
var controller_1 = require("../controller");
var validate_1 = require("./validate");
/**
 * A hook that returns a validation function checking for a record field uniqueness
 * by calling the dataProvider getList function with a filter.
 *
 * @example // Passing options at declaration time
 * const UserCreateForm = () => {
 *     const unique = useUnique({ message: 'Username is already used'});
 *     return (
 *         <SimpleForm>
 *             <TextInput source="username" validate={unique()} />
 *         </SimpleForm>
 *     );
 * }
 *
 * @example // Passing options at call time
 * const UserCreateForm = () => {
 *     const unique = useUnique();
 *     return (
 *         <SimpleForm>
 *             <TextInput source="username" validate={unique({ message: 'Username is already used'})} />
 *         </SimpleForm>
 *     );
 * }
 *
 * @example // With additional filters
 * const UserCreateForm = () => {
 *     const unique = useUnique();
 *     return (
 *         <SimpleForm>
 *             <ReferenceInput source="organization_id" reference="organizations" />
 *             <FormDataConsumer>
 *                 {({ formData }) => (
 *                     <TextInput
 *                         source="username"
 *                         validate={unique({ filter: { organization_id: formData.organization_id })}
 *                     />
 *                 )}
 *             </FormDataConsumer>
 *         </SimpleForm>
 *     );
 * }
 */
var useUnique = function (options) {
    var _a;
    var dataProvider = (0, dataProvider_1.useDataProvider)();
    var translateLabel = (0, i18n_1.useTranslateLabel)();
    var resource = (0, core_1.useResourceContext)(options);
    if (!resource) {
        throw new Error('useUnique: missing resource prop or context');
    }
    var translate = (0, i18n_1.useTranslate)();
    var record = (0, controller_1.useRecordContext)();
    var debouncedGetList = (0, react_1.useRef)(
    // The initial value is here to set the correct type on useRef
    (0, util_1.asyncDebounce)(dataProvider.getList, (_a = options === null || options === void 0 ? void 0 : options.debounce) !== null && _a !== void 0 ? _a : DEFAULT_DEBOUNCE));
    var validateUnique = (0, react_1.useCallback)(function (callTimeOptions) {
        var _a = (0, merge_1.default)({
            debounce: DEFAULT_DEBOUNCE,
            filter: {},
            message: 'ra.validation.unique',
        }, options, callTimeOptions), message = _a.message, filter = _a.filter, interval = _a.debounce;
        debouncedGetList.current = (0, util_1.asyncDebounce)(dataProvider.getList, interval);
        return function (value, allValues, props) { return __awaiter(void 0, void 0, void 0, function () {
            var finalFilter, _a, data, total, error_1;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if ((0, validate_1.isEmpty)(value)) {
                            return [2 /*return*/, undefined];
                        }
                        _b.label = 1;
                    case 1:
                        _b.trys.push([1, 3, , 4]);
                        finalFilter = (0, set_1.default)((0, merge_1.default)({}, filter), props.source, value);
                        return [4 /*yield*/, debouncedGetList.current(resource, {
                                filter: finalFilter,
                                pagination: { page: 1, perPage: 1 },
                                sort: { field: 'id', order: 'ASC' },
                            })];
                    case 2:
                        _a = _b.sent(), data = _a.data, total = _a.total;
                        if (typeof total !== 'undefined' &&
                            total > 0 &&
                            !data.some(function (r) { return r.id === (record === null || record === void 0 ? void 0 : record.id); })) {
                            return [2 /*return*/, {
                                    message: message,
                                    args: {
                                        source: props.source,
                                        value: value,
                                        field: translateLabel({
                                            label: props.label,
                                            source: props.source,
                                            resource: resource,
                                        }),
                                    },
                                }];
                        }
                        return [3 /*break*/, 4];
                    case 3:
                        error_1 = _b.sent();
                        return [2 /*return*/, translate('ra.notification.http_error')];
                    case 4: return [2 /*return*/, undefined];
                }
            });
        }); };
    }, [dataProvider, options, record, resource, translate, translateLabel]);
    return validateUnique;
};
exports.useUnique = useUnique;
var DEFAULT_DEBOUNCE = 1000;
//# sourceMappingURL=useUnique.js.map