"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.I18nContext = void 0;
var react_1 = require("react");
var substituteTokens_1 = require("./substituteTokens");
var defaultI18nProvider = {
    translate: function (key, options) {
        return (options === null || options === void 0 ? void 0 : options._)
            ? (0, substituteTokens_1.substituteTokens)(options._, options)
            : (0, substituteTokens_1.substituteTokens)(key, options);
    },
    changeLocale: function () { return Promise.resolve(); },
    getLocale: function () { return 'en'; },
};
exports.I18nContext = (0, react_1.createContext)(defaultI18nProvider);
exports.I18nContext.displayName = 'I18nContext';
//# sourceMappingURL=I18nContext.js.map