"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.I18nContextProvider = void 0;
var React = __importStar(require("react"));
var react_1 = require("react");
var I18nContext_1 = require("./I18nContext");
var useStore_1 = require("../store/useStore");
var notification_1 = require("../notification");
/**
 * Store the i18nProvider in a context, and rerender children when the locale changes
 */
var I18nContextProvider = function (_a) {
    var _b = _a.value, value = _b === void 0 ? defaulti18nContext : _b, children = _a.children;
    var locale = (0, useStore_1.useStore)('locale')[0];
    var notify = (0, notification_1.useNotify)();
    var _c = (0, react_1.useState)(0), key = _c[0], setKey = _c[1];
    // to avoid blinking effect, delay first render if the user has a non-default locale
    var _d = (0, react_1.useState)(locale === value.getLocale()), isInitialized = _d[0], setInitialized = _d[1];
    // watch store for locale changes
    (0, react_1.useEffect)(function () {
        if (locale && value.getLocale() !== locale) {
            new Promise(function (resolve) {
                // so we systematically return a Promise for the messages
                // i18nProvider may return a Promise for language changes,
                resolve(value.changeLocale(locale));
            })
                .then(function () {
                // Force full page re-render.
                // This is slow on locale change, but it's a good way
                // to avoid having one subscription to the locale
                // for each call to translate()
                setKey(function (key) { return key + 1; });
                setInitialized(true);
            })
                .catch(function (error) {
                setInitialized(true);
                notify('ra.notification.i18n_error', { type: 'error' });
                console.error(error);
            });
        }
        else {
            setInitialized(true);
        }
    }, [value, locale, notify]);
    return isInitialized ? (React.createElement(I18nContext_1.I18nContext.Provider, { value: value, key: key }, children)) : null;
};
exports.I18nContextProvider = I18nContextProvider;
var defaulti18nContext = {
    translate: function (x) { return x; },
    changeLocale: function () { return Promise.resolve(); },
    getLocale: function () { return 'en'; },
};
//# sourceMappingURL=I18nContextProvider.js.map