"use strict";
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeTranslations = exports.resolveBrowserLocale = void 0;
var merge_1 = __importDefault(require("lodash/merge"));
var index_1 = require("./index");
/**
 * Resolve the browser locale according to the value of the global window.navigator
 *
 * Use it to determine the <Admin> locale at runtime.
 *
 * @example
 *    import * as React from "react";
 *    import { Admin, Resource, resolveBrowserLocale } from 'react-admin';
 *    import polyglotI18nProvider from 'ra-i18n-polyglot';
 *    import englishMessages from 'ra-language-english';
 *    import frenchMessages from 'ra-language-french';
 *
 *    const messages = {
 *        fr: frenchMessages,
 *        en: englishMessages,
 *    };
 *    const i18nProvider = polyglotI18nProvider(
 *        locale => messages[locale] ? messages[locale] : messages.en,
 *        resolveBrowserLocale()
 *    );
 *
 *    const App = () => (
 *        <Admin i18nProvider={i18nProvider}>
 *            ...
 *        </Admin>
 *    );
 *
 * @param {string} defaultLocale Defaults to 'en'
 * @param options
 * @param {boolean} options.fullLocale Defaults to false
 */
var resolveBrowserLocale = function (defaultLocale, options) {
    // from http://blog.ksol.fr/user-locale-detection-browser-javascript/
    // Rely on the window.navigator object to determine user locale
    var _a = window.navigator, language = _a.language, browserLanguage = _a.browserLanguage, userLanguage = _a.userLanguage;
    var locale = language ||
        browserLanguage ||
        userLanguage ||
        defaultLocale ||
        index_1.DEFAULT_LOCALE;
    return (options === null || options === void 0 ? void 0 : options.fullLocale) ? locale : locale.split('-')[0];
};
exports.resolveBrowserLocale = resolveBrowserLocale;
/**
 * Compose translations from multiple packages for a single language (eg: 'english').
 *
 * Use it to merge translations from addons with the main react-admin translations.
 *
 * @example
 *     import * as React from "react";
 *     import { Admin, Resource, mergeTranslations } from 'react-admin';
 *     import polyglotI18nProvider from 'ra-i18n-polyglot';
 *     import englishMessages from 'ra-language-english';
 *     import englishTreeMessages from 'ra-tree-language-english';
 *
 *     const messages = {
 *        en: mergeTranslations(englishMessages, englishTreeMessages),
 *     };
 *     const i18nProvider = polyglotI18nProvider(
 *        locale => messages[locale] ? messages[locale] : messages.en
 *    );
 *
 *    const App = () => (
 *        <Admin i18nProvider={i18nProvider}>
 *            ...
 *        </Admin>
 *    );
 */
var mergeTranslations = function () {
    var translationsModules = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        translationsModules[_i] = arguments[_i];
    }
    return merge_1.default.apply(void 0, __spreadArray([{}], translationsModules, false));
};
exports.mergeTranslations = mergeTranslations;
//# sourceMappingURL=TranslationUtils.js.map