"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useI18nProvider = void 0;
var react_1 = require("react");
var I18nContext_1 = require("./I18nContext");
/**
 * Get the i18nProvider instance declared in the <Admin> component
 *
 * @example
 *
 * const CurrentLanguage = () => {
 *    const i18nProvider = useI18nProvider();
 *    const locale = i18nProvider.getLocale();
 *    return <span>{locale}</span>;
 * };
 */
var useI18nProvider = function () { return (0, react_1.useContext)(I18nContext_1.I18nContext); };
exports.useI18nProvider = useI18nProvider;
//# sourceMappingURL=useI18nProvider.js.map