"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useLocaleState = void 0;
var react_1 = require("react");
var useI18nProvider_1 = require("./useI18nProvider");
var useStore_1 = require("../store/useStore");
/**
 * Get the current locale and the ability to change it
 *
 * @example
 *
 * import { useLocaleState } from 'react-admin';
 *
 * const availableLanguages = {
 *     en: 'English',
 *     fr: 'Français',
 * }
 * const LocaleSwitcher = () => {
 *     const [locale, setLocale] = useLocaleState();
 *     return (
 *         <div>
 *             <div>Language</div>
 *             <Button disabled={locale === 'fr'} onClick={() => setLocale('fr')}>
 *                 English
 *             </Button>
 *             <Button disabled={locale === 'en'} onClick={() => setLocale('en')}>
 *                 French
 *             </Button>
 *         </div>
 *     );
 * };
 */
var useLocaleState = function () {
    var i18nProvider = (0, useI18nProvider_1.useI18nProvider)();
    var defaultLocale = (0, react_1.useMemo)(function () { return i18nProvider.getLocale(); }, [i18nProvider]);
    return (0, useStore_1.useStore)('locale', defaultLocale);
};
exports.useLocaleState = useLocaleState;
//# sourceMappingURL=useLocaleState.js.map