"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useSetLocale = void 0;
var useLocaleState_1 = require("./useLocaleState");
/**
 * Set the current locale in the I18nContext and re-render the app when the locale changes.
 *
 * @example
 *
 * import { useSetLocale } from 'react-admin';
 *
 * const availableLanguages = {
 *     en: 'English',
 *     fr: 'Français',
 * }
 * const LanguageSwitcher = () => {
 *     const setLocale = useSetLocale();
 *     return (
 *         <ul>{
 *             Object.keys(availableLanguages).map(locale => {
 *                  <li key={locale} onClick={() => setLocale(locale)}>
 *                      {availableLanguages[locale]}
 *                  </li>
 *              })
 *         }</ul>
 *     );
 * }
 */
var useSetLocale = function () {
    var _a = (0, useLocaleState_1.useLocaleState)(), setLocale = _a[1];
    return setLocale;
};
exports.useSetLocale = useSetLocale;
//# sourceMappingURL=useSetLocale.js.map