import { TranslatableContextValue } from './TranslatableContext';
/**
 * Hook supplying the logic to translate a field value in multiple languages.
 *
 * @param options The hook options
 * @param {string} options.defaultLocale The locale of the default selected locale. Defaults to 'en'.
 * @param {string[]} options.locales An array of the supported locales. Each is an object with a locale and a name property. For example { locale: 'en', name: 'English' }.
 *
 * @returns
 * An object with following properties and methods:
 * - selectedLocale: The locale of the currently selected locale
 * - locales: An array of the supported locales
 * - getLabel: A function which returns the translated label for the given field
 * - getSource: A function which returns the source for the given field
 * - selectLocale: A function which set the selected locale
 */
export declare const useTranslatable: (options: UseTranslatableOptions) => TranslatableContextValue;
export type UseTranslatableOptions = {
    defaultLocale?: string;
    locales: string[];
};
/**
 * Returns a record where translatable fields have their values set to the value of the given locale.
 * This is necessary because the fields rely on the RecordContext to get their values and have no knowledge of the locale.
 *
 * Given the record { title: { en: 'title_en', fr: 'title_fr' } } and the locale 'fr',
 * the record for the locale 'fr' will be { title: 'title_fr' }
 */
export declare const getRecordForLocale: (record: {} | undefined, locale: string) => {} | undefined;
//# sourceMappingURL=useTranslatable.d.ts.map