"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useTranslate = void 0;
var react_1 = require("react");
var useI18nProvider_1 = require("./useI18nProvider");
/**
 * Translate a string using the current locale and the translations from the i18nProvider
 *
 * @see Polyglot.t()
 * @link https://airbnb.io/polyglot.js/#polyglotprototypetkey-interpolationoptions
 *
 * @return {Function} A translation function, accepting two arguments
 *   - a string used as key in the translations
 *   - an interpolationOptions object
 *
 * @example
 *
 * import { useTranslate } from 'react-admin';
 *
 * const SettingsMenu = () => {
 *     const translate = useTranslate();
 *     return <MenuItem>{translate('settings')}</MenuItem>;
 * }
 */
var useTranslate = function () {
    var i18nProvider = (0, useI18nProvider_1.useI18nProvider)();
    var translate = (0, react_1.useCallback)(function (key, options) {
        return i18nProvider.translate(key, options);
    }, 
    // update the hook each time the locale changes
    [i18nProvider] // eslint-disable-line react-hooks/exhaustive-deps
    );
    return i18nProvider ? translate : identity;
};
exports.useTranslate = useTranslate;
var identity = function (key) { return key; };
//# sourceMappingURL=useTranslate.js.map