"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useNotify = void 0;
var react_1 = require("react");
var useAddNotificationContext_1 = require("./useAddNotificationContext");
/**
 * Hook for Notification Side Effect
 *
 * @example
 *
 * const notify = useNotify();
 * // simple message (info level)
 * notify('Level complete');
 * // specify level
 * notify('A problem occurred', { type: 'error' })
 * // pass arguments to the translation function
 * notify('Deleted %{count} elements', { type: 'info', messageArgs: { smart_count: 23 } })
 * // show the action as undoable in the notification
 * notify('Post renamed', { type: 'info', undoable: true })
 */
var useNotify = function () {
    var addNotification = (0, useAddNotificationContext_1.useAddNotificationContext)();
    return (0, react_1.useCallback)(function (message, options) {
        if (options === void 0) { options = {}; }
        var _a = options.type, messageType = _a === void 0 ? 'info' : _a, notificationOptions = __rest(options, ["type"]);
        addNotification({
            message: message,
            type: messageType,
            notificationOptions: notificationOptions,
        });
    }, [addNotification]);
};
exports.useNotify = useNotify;
//# sourceMappingURL=useNotify.js.map