"use strict";
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.usePreferenceInput = void 0;
var react_1 = require("react");
var usePreference_1 = require("./usePreference");
/**
 * Get the props for a preference input that changes the value on blur
 *
 * Relies on `usePreference`, so it's using the PreferenceKeyContext
 *
 * @example
 * const FontSizePreferenceInput = () => {
 *     const field = usePreferenceInput('ui.font.size', 10);
 *     return (
 *         <div>
 *             <label for="font-size">Font size</label>
 *             <input id="font-size" {...field} />
 *         </div>
 *     );
 * }
 */
var usePreferenceInput = function (key, defaultValue) {
    var _a = (0, usePreference_1.usePreference)(key, defaultValue), valueFromStore = _a[0], setValueFromStore = _a[1];
    var _b = (0, react_1.useState)(valueFromStore), value = _b[0], setValue = _b[1];
    (0, react_1.useEffect)(function () {
        setValue(valueFromStore || defaultValue);
    }, [valueFromStore, defaultValue]);
    var onChange = function (event) {
        setValue(event.target.value === '' ? defaultValue : event.target.value);
    };
    var onBlur = function () {
        setValueFromStore(value);
    };
    var onKeyDown = function (event) {
        var _a;
        if (event.key === 'Enter') {
            setValueFromStore(value);
            var form = event.target.form;
            if (form) {
                var index = __spreadArray([], form, true).indexOf(event.target);
                (_a = form.elements[index + 1]) === null || _a === void 0 ? void 0 : _a.focus();
            }
            event.preventDefault();
        }
    };
    return { value: value, onChange: onChange, onBlur: onBlur, onKeyDown: onKeyDown };
};
exports.usePreferenceInput = usePreferenceInput;
//# sourceMappingURL=usePreferenceInput.js.map