"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RestoreScrollPosition = void 0;
var useRestoreScrollPosition_1 = require("./useRestoreScrollPosition");
/**
 * A component that tracks the scroll position and restores it when the component mounts.
 * @param children The content to render
 * @param key The key under which to store the scroll position in the store
 * @param debounceMs The debounce time in milliseconds
 *
 * @example
 * import { RestoreScrollPosition } from 'ra-core';
 *
 * const MyCustomPage = () => {
 *   <RestoreScrollPosition key="my-list">
 *     <div>
 *       <h1>My Custom Page</h1>
 *       <VeryLongContent />
 *     </div>
 *   </RestoreScrollPosition>
 * };
 */
var RestoreScrollPosition = function (_a) {
    var children = _a.children, storeKey = _a.storeKey, _b = _a.debounce, debounce = _b === void 0 ? 250 : _b;
    (0, useRestoreScrollPosition_1.useRestoreScrollPosition)(storeKey, debounce);
    return children;
};
exports.RestoreScrollPosition = RestoreScrollPosition;
//# sourceMappingURL=RestoreScrollPosition.js.map