"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StoreSetter = void 0;
var React = __importStar(require("react"));
var react_1 = require("react");
var useStoreContext_1 = require("./useStoreContext");
/**
 * A component to set store state for a key on mount declaratively
 *
 * To use it, just wrap any component that need to use the corresponding
 * store item with <StoreSetter name="my.key" value="myvalue">.
 * This wrapping needs to be done to ensure that the corresponding store item
 * is set before rendering the wrapped component.
 *
 * Tip: <StoreSetter> is a great helper for mocking the store in
 * unit tests. Prefer it to calling the Store manually.
 *
 * @example
 *
 *     <StoreSetter name="list.density" value="small">
 *         <MyStoreDependentComponent />
 *     </StoreSetter>
 *
 * @example // Using <StoreSetter> is equivalent to using `useStoreContext` and setting its value directly.
 *
 * const [, setDensity] = useStore('list.density');
 *
 * useEffect(() => {
 *     setDensity('small');
 * }, []);
 *
 * @param {Props}    props
 * @param {string}   props.name Store item key. Required. Separate with dots to namespace, e.g. 'posts.list.columns'
 * @param {any}      props.value Store item value. Required.
 * @param {children} props.children Children are rendered as is, on mount
 */
var StoreSetter = function (_a) {
    var value = _a.value, name = _a.name, children = _a.children;
    var setItem = (0, useStoreContext_1.useStoreContext)().setItem;
    (0, react_1.useEffect)(function () {
        setItem(name, value);
    }, [name, setItem, value]);
    return React.createElement(React.Fragment, null, children);
};
exports.StoreSetter = StoreSetter;
//# sourceMappingURL=StoreSetter.js.map