"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useRemoveFromStore = void 0;
var react_1 = require("react");
var useStoreContext_1 = require("./useStoreContext");
/**
 * Get a callback to remove an item from the store
 *
 * @example
 * import { useRemoveFromStore } from 'react-admin';
 *
 * const ResetDatagridPrefs = () {
 *    const removeItem = useRemoveFromStore();
 *
 *    const handleClick = () => {
 *        removeItem('datagrid.prefs');
 *    };
 *
 *    return <Button onClick={hancleClick}>Reset datagrid preferences</Button>;
 * }
 */
var useRemoveFromStore = function (hookTimeKey) {
    var removeItem = (0, useStoreContext_1.useStoreContext)().removeItem;
    return (0, react_1.useCallback)(function (key) {
        if (typeof key === 'undefined' &&
            typeof hookTimeKey === 'undefined') {
            throw new Error('You must provide a key to remove an item from the store');
        }
        // @ts-ignore
        return removeItem(key !== null && key !== void 0 ? key : hookTimeKey);
    }, [removeItem, hookTimeKey]);
};
exports.useRemoveFromStore = useRemoveFromStore;
//# sourceMappingURL=useRemoveFromStore.js.map