"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useRemoveItemsFromStore = void 0;
var react_1 = require("react");
var useStoreContext_1 = require("./useStoreContext");
/**
 * Get a callback to remove all item with a certain key prefix from the store
 *
 * @example
 * import { useRemoveItemsFromStore } from 'react-admin';
 *
 * const ResetDatagridPrefs = () {
 *    const removeItems = useRemoveItemsFromStore();
 *
 *    const handleClick = () => {
 *        removeItems('datagrid.prefs');
 *    };
 *
 *    return <Button onClick={hancleClick}>Reset datagrid preferences</Button>;
 * }
 */
var useRemoveItemsFromStore = function (hookTimeKeyPrefix) {
    var removeItems = (0, useStoreContext_1.useStoreContext)().removeItems;
    return (0, react_1.useCallback)(function (keyPrefix) {
        if (typeof keyPrefix === 'undefined' &&
            typeof hookTimeKeyPrefix === 'undefined') {
            throw new Error('You must provide a key to remove an item from the store');
        }
        // @ts-ignore
        return removeItems(keyPrefix !== null && keyPrefix !== void 0 ? keyPrefix : hookTimeKeyPrefix);
    }, [removeItems, hookTimeKeyPrefix]);
};
exports.useRemoveItemsFromStore = useRemoveItemsFromStore;
//# sourceMappingURL=useRemoveItemsFromStore.js.map