"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useResetStore = void 0;
var useStoreContext_1 = require("./useStoreContext");
/**
 * Get a callback to remove all items from the store
 *
 * @example
 * import { useResetStore } from 'react-admin';
 *
 * const ResetPrefs = () {
 *    const reset = useResetStore();
 *
 *    const handleClick = () => {
 *        reset();
 *    };
 *
 *    return <Button onClick={handleClick}>Reset preferences</Button>;
 * }
 */
var useResetStore = function () {
    var reset = (0, useStoreContext_1.useStoreContext)().reset;
    return reset;
};
exports.useResetStore = useResetStore;
//# sourceMappingURL=useResetStore.js.map