"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.asyncDebounce = void 0;
var debounce_1 = __importDefault(require("lodash/debounce"));
/**
 * A version of lodash/debounce that always returns a promise but wait for the debounced function to return to resolve it.
 * @param func The function to debounce
 * @param wait The debounce delay
 * @returns A debounced function that returns a promise
 */
function asyncDebounce(func, wait) {
    var resolveSet = new Set();
    var rejectSet = new Set();
    var debounced = (0, debounce_1.default)(function (args) {
        func.apply(void 0, args).then(function () {
            var res = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                res[_i] = arguments[_i];
            }
            resolveSet.forEach(function (resolve) { return resolve.apply(void 0, res); });
        })
            .catch(function () {
            var res = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                res[_i] = arguments[_i];
            }
            rejectSet.forEach(function (reject) { return reject.apply(void 0, res); });
        })
            .finally(function () {
            resolveSet.clear();
            rejectSet.clear();
        });
    }, wait);
    return function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        return new Promise(function (resolve, reject) {
            resolveSet.add(resolve);
            rejectSet.add(reject);
            debounced(args);
        });
    };
}
exports.asyncDebounce = asyncDebounce;
//# sourceMappingURL=asyncDebounce.js.map