"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useCheckForApplicationUpdate = void 0;
var react_1 = require("react");
var useEvent_1 = require("./useEvent");
/**
 * Checks if the application code has changed and calls the provided onNewVersionAvailable function when needed.
 *
 * It checks for code update by downloading the provided URL (default to the HTML page) and
 * comparing the hash of the response with the hash of the current page.
 *
 * @param {UseCheckForApplicationUpdateOptions} options The options
 * @param {Function} options.onNewVersionAvailable The function to call when a new version of the application is available.
 * @param {string} options.url Optional. The URL to download to check for code update. Defaults to the current URL.
 * @param {RequestInit} options.fetchOptions Optional. The options passed to fetch function when checking for update.
 * @param {number} options.interval Optional. The interval in milliseconds between two checks. Defaults to 3600000 (1 hour).
 * @param {boolean} options.disabled Optional. Whether the check should be disabled. Defaults to false.
 */
var useCheckForApplicationUpdate = function (options) {
    var _a = options.url, url = _a === void 0 ? window.location.href : _a, fetchOptions = options.fetchOptions, _b = options.interval, delay = _b === void 0 ? ONE_HOUR : _b, onNewVersionAvailableProp = options.onNewVersionAvailable, _c = options.disabled, disabled = _c === void 0 ? process.env.NODE_ENV !== 'production' : _c;
    var currentHash = (0, react_1.useRef)();
    var onNewVersionAvailable = (0, useEvent_1.useEvent)(onNewVersionAvailableProp);
    (0, react_1.useEffect)(function () {
        if (disabled)
            return;
        getHashForUrl(url, fetchOptions).then(function (hash) {
            if (hash != null) {
                currentHash.current = hash;
            }
        });
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [disabled, url, JSON.stringify(fetchOptions)]);
    (0, react_1.useEffect)(function () {
        if (disabled)
            return;
        var interval = setInterval(function () {
            getHashForUrl(url, fetchOptions)
                .then(function (hash) {
                if (hash != null && currentHash.current !== hash) {
                    // Store the latest hash to avoid calling the onNewVersionAvailable function multiple times
                    // or when users have closed the notification
                    currentHash.current = hash;
                    onNewVersionAvailable();
                }
            })
                .catch(function () {
                // Ignore errors to avoid issues when connectivity is lost
            });
        }, delay);
        return function () { return clearInterval(interval); };
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [
        delay,
        onNewVersionAvailable,
        disabled,
        url,
        // eslint-disable-next-line react-hooks/exhaustive-deps
        JSON.stringify(fetchOptions),
    ]);
};
exports.useCheckForApplicationUpdate = useCheckForApplicationUpdate;
var getHashForUrl = function (url, fetchOptions) { return __awaiter(void 0, void 0, void 0, function () {
    var response, text, e_1;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                _a.trys.push([0, 3, , 4]);
                return [4 /*yield*/, fetch(url, fetchOptions)];
            case 1:
                response = _a.sent();
                if (!response.ok)
                    return [2 /*return*/, null];
                return [4 /*yield*/, response.text()];
            case 2:
                text = _a.sent();
                return [2 /*return*/, hash(text)];
            case 3:
                e_1 = _a.sent();
                return [2 /*return*/, null];
            case 4: return [2 /*return*/];
        }
    });
}); };
// Simple hash function, taken from https://stackoverflow.com/a/52171480/3723993, suggested by Copilot
var hash = function (value, seed) {
    if (seed === void 0) { seed = 0; }
    var h1 = 0xdeadbeef ^ seed, h2 = 0x41c6ce57 ^ seed;
    for (var i = 0, ch = void 0; i < value.length; i++) {
        ch = value.charCodeAt(i);
        h1 = Math.imul(h1 ^ ch, 2654435761);
        h2 = Math.imul(h2 ^ ch, 1597334677);
    }
    h1 = Math.imul(h1 ^ (h1 >>> 16), 2246822507);
    h1 ^= Math.imul(h2 ^ (h2 >>> 13), 3266489909);
    h2 = Math.imul(h2 ^ (h2 >>> 16), 2246822507);
    h2 ^= Math.imul(h1 ^ (h1 >>> 13), 3266489909);
    return 4294967296 * (2097151 & h2) + (h1 >>> 0);
};
var ONE_HOUR = 1000 * 60 * 60;
//# sourceMappingURL=useCheckForApplicationUpdate.js.map