import { ExtractRecordPaths } from '../types';
/**
 * A hook that gets the value of a field of the current record.
 * @param params The hook parameters
 * @param params.source The field source
 * @param params.record The record to use. Uses the record from the RecordContext if not provided
 * @param params.defaultValue The value to return when the field value is empty
 * @returns The field value
 *
 * @example
 * const MyField = (props: { source: string }) => {
 *   const value = useFieldValue(props);
 *   return <span>{value}</span>;
 * }
 */
export declare const useFieldValue: <RecordType extends Record<string, any> = Record<string, any>>(params: UseFieldValueOptions<RecordType>) => any;
export interface UseFieldValueOptions<RecordType extends Record<string, any> = Record<string, any>> {
    defaultValue?: any;
    source: ExtractRecordPaths<RecordType>;
    record?: RecordType;
}
//# sourceMappingURL=useFieldValue.d.ts.map