import * as React from 'react';
import { useAuthenticated } from './useAuthenticated';
/**
 * Restrict access to children to authenticated users.
 * Redirects anonymous users to the login page.
 *
 * Use it to decorate your custom page components to require
 * authentication.
 *
 * @see useAuthState
 *
 * @example
 * import { Admin, CustomRoutes, Authenticated } from 'react-admin';
 *
 * const customRoutes = [
 *     <Route
 *         path="/foo"
 *         element={
 *             <Authenticated authParams={{ foo: 'bar' }}>
 *                 <Foo />
 *             </Authenticated>
 *         }
 *     />
 * ];
 * const App = () => (
 *     <Admin>
 *         <CustomRoutes>{customRoutes}</CustomRoutes>
 *     </Admin>
 * );
 */
export var Authenticated = function (props) {
    var authParams = props.authParams, _a = props.loading, loading = _a === void 0 ? null : _a, children = props.children;
    // this hook will redirect to login if the user is not authenticated
    var isPending = useAuthenticated({ params: authParams }).isPending;
    if (isPending) {
        return loading;
    }
    return React.createElement(React.Fragment, null, children);
};
//# sourceMappingURL=Authenticated.js.map