var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { useCanAccess } from './useCanAccess';
import { Navigate } from 'react-router';
/**
 * A component that only displays its children after checking whether users are authorized to access the provided resource and action.
 * @param options
 * @param options.action The action to check. One of 'list', 'create', 'edit', 'show', 'delete', or a custom action.
 * @param options.resource The resource to check. e.g. 'posts', 'comments', 'users'
 * @param options.children The component to render if users are authorized.
 * @param options.loading An optional element to render while the authorization is being checked. Defaults to null.
 * @param options.accessDenied An optional element to render if users are denied access. Defaults to null.
 * @param options.error An optional element to render if an error occur while checking users access rights. Redirect users to `/authentication-error` by default.
 */
export var CanAccess = function (_a) {
    var children = _a.children, _b = _a.loading, loading = _b === void 0 ? null : _b, _c = _a.accessDenied, accessDenied = _c === void 0 ? null : _c, _d = _a.error, errorElement = _d === void 0 ? DEFAULT_ERROR : _d, props = __rest(_a, ["children", "loading", "accessDenied", "error"]);
    var _e = useCanAccess(props), canAccess = _e.canAccess, error = _e.error, isPending = _e.isPending;
    if (isPending) {
        return loading;
    }
    if (error) {
        return errorElement;
    }
    if (canAccess === false) {
        return accessDenied;
    }
    return children;
};
var DEFAULT_ERROR = React.createElement(Navigate, { to: "/authentication-error" });
//# sourceMappingURL=CanAccess.js.map