var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import useAuthState from './useAuthState';
/**
 * Restrict access to authenticated users.
 * Redirect anonymous users to the login page.
 *
 * Use it in your custom page components to require
 * authentication.
 *
 * You can set additional `authParams` at will if your authProvider
 * requires it.
 *
 * @example
 * import { Admin, CustomRoutes, useAuthenticated } from 'react-admin';
 *
 * const FooPage = () => {
 *     const { isPending } = useAuthenticated();
 *     if (isPending) return null;
 *     return <Foo />;
 * }
 *
 * const customRoutes = [
 *     <Route path="/foo" element={<FooPage />} />
 * ];
 *
 * const App = () => (
 *     <Admin>
 *         <CustomRoutes>{customRoutes}</CustomRoutes>
 *     </Admin>
 * );
 */
export var useAuthenticated = function (_a) {
    if (_a === void 0) { _a = {}; }
    var params = _a.params, _b = _a.logoutOnFailure, logoutOnFailure = _b === void 0 ? true : _b, options = __rest(_a, ["params", "logoutOnFailure"]);
    return useAuthState(params !== null && params !== void 0 ? params : emptyParams, logoutOnFailure, options);
};
var emptyParams = {};
//# sourceMappingURL=useAuthenticated.js.map