var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { useQueryClient } from '@tanstack/react-query';
import { useResourceContext } from '../core';
import useAuthProvider from './useAuthProvider';
/**
 * A hook that returns true if the authProvider is currently checking the authentication status or the user's access rights.
 * @param params
 * @param params.action The action to check access for
 * @param params.resource The resource to check access for (optional). Defaults to the resource of the current ResourceContext.
 * @returns {boolean} true if the authProvider is currently checking the authentication status or the user's access rights, false otherwise.
 */
export var useIsAuthPending = function (params) {
    var action = params.action, props = __rest(params, ["action"]);
    var queryClient = useQueryClient();
    var authProvider = useAuthProvider();
    var resource = useResourceContext(props);
    if (!authProvider) {
        return false;
    }
    var authQueryState = queryClient.getQueryState(['auth', 'checkAuth', {}]);
    var canAccessQueryState = queryClient.getQueryState([
        'auth',
        'canAccess',
        { action: action, resource: resource },
    ]);
    if ((authQueryState === null || authQueryState === void 0 ? void 0 : authQueryState.status) === 'pending' ||
        (authProvider.canAccess && (canAccessQueryState === null || canAccessQueryState === void 0 ? void 0 : canAccessQueryState.status) === 'pending')) {
        return true;
    }
    return false;
};
//# sourceMappingURL=useIsAuthPending.js.map