var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import * as React from 'react';
import { RecordContextProvider } from '../record/RecordContext';
import { CreateContext } from './CreateContext';
import { SaveContextProvider, usePickSaveContext } from '../saveContext';
/**
 * Create a Create Context.
 *
 * @example
 *
 * const MyCreate = (props) => {
 *     const controllerProps = useCreateController(props);
 *     return (
 *         <CreateContextProvider value={controllerProps}>
 *             <MyCreateView>
 *         </CreateContextProvider>
 *     );
 * };
 *
 * const MyCreateView = () => {
 *     const record = useRecordContext();
 *     // or, to rerender only when the save operation change but not data
 *     const { saving } = useCreateContext();
 * }
 *
 * @see CreateContext
 * @see RecordContext
 */
export var CreateContextProvider = function (_a) {
    var children = _a.children, value = _a.value;
    return (React.createElement(CreateContext.Provider, { value: value },
        React.createElement(SaveContextProvider, { value: __assign(__assign({}, usePickSaveContext(value)), { mutationMode: 'pessimistic' }) },
            React.createElement(RecordContextProvider, { value: value && value.record }, children))));
};
//# sourceMappingURL=CreateContextProvider.js.map