import { useContext } from 'react';
import { CreateContext } from './CreateContext';
/**
 * Hook to read the create controller props from the CreateContext.
 *
 * Used within a <CreateContextProvider> (e.g. as a descendent of <Create>).
 *
 * @returns {CreateControllerResult} create controller props
 *
 * @see useCreateController for how it is filled
 */
export var useCreateContext = function () {
    var context = useContext(CreateContext);
    if (!context) {
        throw new Error('useCreateContext must be used inside a CreateContextProvider');
    }
    return context;
};
//# sourceMappingURL=useCreateContext.js.map