import { RaRecord } from '../../types';
import { EditControllerResult } from './useEditController';
/**
 * Hook to read the edit controller props from the EditContext.
 *
 * Used within a <EditContextProvider> (e.g. as a descendent of <Edit>).
 *
 * @returns {EditControllerResult} edit controller props
 *
 * @see useEditController for how it is filled
 */
export declare const useEditContext: <RecordType extends RaRecord<import("../../types").Identifier> = any>() => EditControllerResult<RecordType>;
//# sourceMappingURL=useEditContext.d.ts.map