import { useContext } from 'react';
import { EditContext } from './EditContext';
/**
 * Hook to read the edit controller props from the EditContext.
 *
 * Used within a <EditContextProvider> (e.g. as a descendent of <Edit>).
 *
 * @returns {EditControllerResult} edit controller props
 *
 * @see useEditController for how it is filled
 */
export var useEditContext = function () {
    var context = useContext(EditContext);
    if (!context) {
        throw new Error('useEditContext must be used inside an EditContextProvider');
    }
    return context;
};
//# sourceMappingURL=useEditContext.js.map