var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import get from 'lodash/get';
import { useGetManyAggregate } from '../../dataProvider';
import { useList } from '../list';
import { useNotify } from '../../notification';
var emptyArray = [];
var defaultFilter = {};
/**
 * Hook that fetches records from another resource specified
 * by an array of *ids* in current record.
 *
 * @example
 *
 * const { data, error, isFetching, isPending } = useReferenceArrayFieldController({
 *      record: { referenceIds: ['id1', 'id2']};
 *      reference: 'reference';
 *      resource: 'resource';
 *      source: 'referenceIds';
 * });
 *
 * @param {Object} props
 * @param {Object} props.record The current resource record
 * @param {string} props.reference The linked resource name
 * @param {string} props.resource The current resource name
 * @param {string} props.source The key of the linked resource identifier
 *
 * @param {Props} props
 *
 * @returns {ListControllerResult} The reference props
 */
export var useReferenceArrayFieldController = function (props) {
    var _a = props.filter, filter = _a === void 0 ? defaultFilter : _a, _b = props.page, page = _b === void 0 ? 1 : _b, _c = props.perPage, perPage = _c === void 0 ? 1000 : _c, record = props.record, reference = props.reference, sort = props.sort, source = props.source, _d = props.queryOptions, queryOptions = _d === void 0 ? {} : _d;
    var notify = useNotify();
    var value = get(record, source);
    var meta = queryOptions.meta, otherQueryOptions = __rest(queryOptions, ["meta"]);
    var ids = Array.isArray(value) ? value : emptyArray;
    var _e = useGetManyAggregate(reference, { ids: ids, meta: meta }, __assign({ onError: function (error) {
            return notify(typeof error === 'string'
                ? error
                : error.message || 'ra.notification.http_error', {
                type: 'error',
                messageArgs: {
                    _: typeof error === 'string'
                        ? error
                        : error && error.message
                            ? error.message
                            : undefined,
                },
            });
        } }, otherQueryOptions)), data = _e.data, error = _e.error, isLoading = _e.isLoading, isFetching = _e.isFetching, isPending = _e.isPending, refetch = _e.refetch;
    var listProps = useList({
        data: data,
        error: error,
        filter: filter,
        isFetching: isFetching,
        isLoading: isLoading,
        isPending: isPending,
        page: page,
        perPage: perPage,
        sort: sort,
    });
    return __assign(__assign({}, listProps), { defaultTitle: undefined, refetch: refetch, resource: reference });
};
//# sourceMappingURL=useReferenceArrayFieldController.js.map