var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { useMemo } from 'react';
import { useGetPathForRecord } from '../../routing';
import { useReference } from '../useReference';
import { useFieldValue } from '../../util';
export var useReferenceFieldController = function (options) {
    var link = options.link, reference = options.reference, queryOptions = options.queryOptions;
    if (!reference) {
        throw new Error('useReferenceFieldController: missing reference prop. You must provide a reference, e.g. reference="posts".');
    }
    var id = useFieldValue(options);
    var referenceRecordQuery = useReference({
        reference: reference,
        id: id,
        options: __assign(__assign({}, queryOptions), { enabled: ((queryOptions === null || queryOptions === void 0 ? void 0 : queryOptions.enabled) == null ||
                (queryOptions === null || queryOptions === void 0 ? void 0 : queryOptions.enabled) === true) &&
                id != null }),
    });
    var path = useGetPathForRecord({
        record: referenceRecordQuery.referenceRecord,
        resource: reference,
        link: link,
    });
    var result = useMemo(function () {
        return (__assign(__assign({}, referenceRecordQuery), { link: path }));
    }, [path, referenceRecordQuery]);
    return result;
};
//# sourceMappingURL=useReferenceFieldController.js.map