var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import get from 'lodash/get';
import { useGetManyReference } from '../../dataProvider';
import { useNotify } from '../../notification';
/**
 * Fetch a reference record in a one-to-one relationship, and return it when available
 *
 * The reference prop should be the name of one of the <Resource> components
 * added as <Admin> child.
 *
 * @example
 *
 * const { data, isPending, error } = useReferenceOneFieldController({
 *     record: { id: 7, name: 'James Joyce'}
 *     reference: 'bios',
 *     target: 'author_id',
 * });
 *
 * @typedef {Object} UseReferenceOneFieldControllerParams
 * @prop {Object} props.record The current resource record
 * @prop {string} props.reference The linked resource name
 * @prop {string} props.target The target resource key
 * @prop {string} props.source The key current record identifier ('id' by default)
 * @prop {Object} props.sort The sort to apply to the referenced records
 * @prop {Object} props.filter The filter to apply to the referenced records
 * @returns {UseReferenceResult} The request state. Destructure as { referenceRecord, isPending, error }.
 */
export var useReferenceOneFieldController = function (props) {
    var reference = props.reference, record = props.record, target = props.target, _a = props.source, source = _a === void 0 ? 'id' : _a, _b = props.sort, sort = _b === void 0 ? { field: 'id', order: 'ASC' } : _b, _c = props.filter, filter = _c === void 0 ? {} : _c, _d = props.queryOptions, queryOptions = _d === void 0 ? {} : _d;
    var notify = useNotify();
    var meta = queryOptions.meta, otherQueryOptions = __rest(queryOptions, ["meta"]);
    var _e = useGetManyReference(reference, {
        target: target,
        id: get(record, source),
        pagination: { page: 1, perPage: 1 },
        sort: sort,
        filter: filter,
        meta: meta,
    }, __assign({ enabled: !!record, onError: function (error) {
            return notify(typeof error === 'string'
                ? error
                : error.message || 'ra.notification.http_error', {
                type: 'error',
                messageArgs: {
                    _: typeof error === 'string'
                        ? error
                        : error && error.message
                            ? error.message
                            : undefined,
                },
            });
        } }, otherQueryOptions)), data = _e.data, error = _e.error, isFetching = _e.isFetching, isLoading = _e.isLoading, isPending = _e.isPending, refetch = _e.refetch;
    return {
        referenceRecord: data ? data[0] : undefined,
        error: error,
        isFetching: isFetching,
        isLoading: isLoading,
        isPending: isPending,
        refetch: refetch,
    };
};
//# sourceMappingURL=useReferenceOneFieldController.js.map