import { Reducer } from 'react';
import { ListParams } from './useListParams';
export declare const SET_SORT = "SET_SORT";
export declare const SORT_ASC = "ASC";
export declare const SORT_DESC = "DESC";
export declare const SET_PAGE = "SET_PAGE";
export declare const SET_PER_PAGE = "SET_PER_PAGE";
export declare const SET_FILTER = "SET_FILTER";
export declare const SHOW_FILTER = "SHOW_FILTER";
export declare const HIDE_FILTER = "HIDE_FILTER";
type ActionTypes = {
    type: typeof SET_SORT;
    payload: {
        field: string;
        order?: typeof SORT_ASC | typeof SORT_DESC;
    };
} | {
    type: typeof SET_PAGE;
    payload: number;
} | {
    type: typeof SET_PER_PAGE;
    payload: number;
} | {
    type: typeof SET_FILTER;
    payload: {
        filter: any;
        displayedFilters?: {
            [key: string]: boolean;
        };
    };
} | {
    type: typeof SHOW_FILTER;
    payload: {
        filterName: string;
        defaultValue?: any;
    };
} | {
    type: typeof HIDE_FILTER;
    payload: string;
};
/**
 * This reducer is for the react-router query string.
 */
export declare const queryReducer: Reducer<ListParams, ActionTypes>;
export default queryReducer;
//# sourceMappingURL=queryReducer.d.ts.map