import { Identifier } from '../../types';
/**
 * State-like hook for controlling the expanded state of a list item
 *
 * @param {string} resource The resource name, e.g. 'posts'
 * @param {string|integer} id The record identifier, e.g. 123
 * @param {boolean} single Forces only one id to be expanded at a time
 * @returns {Object} Destructure as [expanded, toggleExpanded].
 *
 * @example
 *
 * const [expanded, toggleExpanded] = useExpanded('posts', 123);
 * const expandIcon = expanded ? ExpandLess : ExpandMore;
 * const onExpandClick = () => toggleExpanded();
 */
export declare const useExpanded: (resource: string, id: Identifier, single?: boolean) => [boolean, () => void];
/**
 * State-like hook for controlling the expanded state of many list items
 * expanded state is true when at least one item from ids is expanded.
 *
 * @param {string} resource The resource name, e.g. 'posts'
 * @param {Identifier[]} ids A list of record identifiers
 * @returns {Object} Destructure as [expanded, toggleExpanded].
 *
 * @example
 *
 * const [expanded, toggleExpanded] = useExpandAll('posts', [123, 124, 125]);
 * const expandIcon = expanded ? ExpandLess : ExpandMore;
 * const onExpandClick = () => toggleExpanded();
 */
export declare const useExpandAll: (resource: string, ids: Identifier[]) => [boolean, () => void];
//# sourceMappingURL=useExpanded.d.ts.map