import { useContext } from 'react';
import { ListPaginationContext, } from './ListPaginationContext';
/**
 * Hook to read the list pagination controller props from the ListPaginationContext.
 *
 * Must be used within a <ListPaginationContext> (e.g. as a descendent of <List>
 * or <ListBase>).
 *
 * @returns {ListPaginationContextValue} list controller props
 *
 * @see useListController for how it is filled
 */
export var useListPaginationContext = function () {
    var context = useContext(ListPaginationContext);
    if (!context) {
        throw new Error('useListPaginationContext must be used inside a ListPaginationContextProvider');
    }
    return context;
};
//# sourceMappingURL=useListPaginationContext.js.map