var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import { useCallback, useMemo, useEffect, useState, useRef } from 'react';
import { parse, stringify } from 'query-string';
import lodashDebounce from 'lodash/debounce';
import { useNavigate, useLocation } from 'react-router-dom';
import { useStore } from '../../store';
import queryReducer, { SET_FILTER, HIDE_FILTER, SHOW_FILTER, SET_PAGE, SET_PER_PAGE, SET_SORT, SORT_ASC, } from './queryReducer';
import removeEmpty from '../../util/removeEmpty';
import { useIsMounted } from '../../util/hooks';
/**
 * Get the list parameters (page, sort, filters) and modifiers.
 *
 * These parameters are merged from 3 sources:
 *   - the query string from the URL
 *   - the params stored in the state (from previous navigation)
 *   - the options passed to the hook (including the filter defaultValues)
 *
 * @returns {Array} A tuple [parameters, modifiers].
 * Destructure as [
 *    { page, perPage, sort, order, filter, filterValues, displayedFilters, requestSignature },
 *    { setFilters, hideFilter, showFilter, setPage, setPerPage, setSort }
 * ]
 *
 * @example
 *
 * const [listParams, listParamsActions] = useListParams({
 *      resource: 'posts',
 *      location: location // From react-router. Injected to your component by react-admin inside a List
 *      filterDefaultValues: {
 *          published: true
 *      },
 *      sort: {
 *          field: 'published_at',
 *          order: 'DESC'
 *      },
 *      perPage: 25
 * });
 *
 * const {
 *      page,
 *      perPage,
 *      sort,
 *      order,
 *      filter,
 *      filterValues,
 *      displayedFilters,
 *      requestSignature
 * } = listParams;
 *
 * const {
 *      setFilters,
 *      hideFilter,
 *      showFilter,
 *      setPage,
 *      setPerPage,
 *      setSort,
 * } = listParamsActions;
 */
export var useListParams = function (_a) {
    var _b = _a.debounce, debounce = _b === void 0 ? 500 : _b, _c = _a.disableSyncWithLocation, disableSyncWithLocation = _c === void 0 ? false : _c, filterDefaultValues = _a.filterDefaultValues, _d = _a.perPage, perPage = _d === void 0 ? 10 : _d, resource = _a.resource, _e = _a.sort, sort = _e === void 0 ? defaultSort : _e, _f = _a.storeKey, storeKey = _f === void 0 ? disableSyncWithLocation ? false : "".concat(resource, ".listParams") : _f;
    var location = useLocation();
    var navigate = useNavigate();
    var _g = useState(defaultParams), localParams = _g[0], setLocalParams = _g[1];
    // As we can't conditionally call a hook, if the storeKey is false,
    // we'll ignore the params variable later on and won't call setParams either.
    var _h = useStore(storeKey || "".concat(resource, ".listParams"), defaultParams), params = _h[0], setParams = _h[1];
    var tempParams = useRef();
    var isMounted = useIsMounted();
    var requestSignature = [
        location.search,
        resource,
        storeKey,
        JSON.stringify(!storeKey ? localParams : params),
        JSON.stringify(filterDefaultValues),
        JSON.stringify(sort),
        perPage,
        disableSyncWithLocation,
    ];
    var queryFromLocation = disableSyncWithLocation
        ? {}
        : parseQueryFromLocation(location);
    var query = useMemo(function () {
        return getQuery({
            queryFromLocation: queryFromLocation,
            params: !storeKey ? localParams : params,
            filterDefaultValues: filterDefaultValues,
            sort: sort,
            perPage: perPage,
        });
    }, requestSignature // eslint-disable-line react-hooks/exhaustive-deps
    );
    // if the location includes params (for example from a link like
    // the categories products on the demo), we need to persist them in the
    // store as well so that we don't lose them after a redirection back
    // to the list
    useEffect(function () {
        if (Object.keys(queryFromLocation).length > 0) {
            setParams(query);
        }
    }, [location.search]); // eslint-disable-line
    var changeParams = useCallback(function (action) {
        // do not change params if the component is already unmounted
        // this is necessary because changeParams can be debounced, and therefore
        // executed after the component is unmounted
        if (!isMounted.current)
            return;
        if (!tempParams.current) {
            // no other changeParams action dispatched this tick
            tempParams.current = queryReducer(query, action);
            // schedule side effects for next tick
            setTimeout(function () {
                if (!tempParams.current) {
                    // the side effects were already processed by another changeParams
                    return;
                }
                if (disableSyncWithLocation && !storeKey) {
                    setLocalParams(tempParams.current);
                }
                else if (disableSyncWithLocation && !!storeKey) {
                    setParams(tempParams.current);
                }
                else {
                    // the useEffect above will apply the changes to the params in the store
                    navigate({
                        search: "?".concat(stringify(__assign(__assign({}, tempParams.current), { filter: JSON.stringify(tempParams.current.filter), displayedFilters: JSON.stringify(tempParams.current.displayedFilters) }))),
                    }, {
                        state: {
                            _scrollToTop: action.type === SET_PAGE,
                        },
                    });
                }
                tempParams.current = undefined;
            }, 0);
        }
        else {
            // side effects already scheduled, just change the params
            tempParams.current = queryReducer(tempParams.current, action);
        }
    }, __spreadArray(__spreadArray([], requestSignature, true), [navigate], false));
    var setSort = useCallback(function (sort) {
        return changeParams({
            type: SET_SORT,
            payload: sort,
        });
    }, [changeParams]);
    var setPage = useCallback(function (newPage) { return changeParams({ type: SET_PAGE, payload: newPage }); }, [changeParams]);
    var setPerPage = useCallback(function (newPerPage) {
        return changeParams({ type: SET_PER_PAGE, payload: newPerPage });
    }, [changeParams]);
    var filterValues = query.filter || emptyObject;
    var displayedFilterValues = query.displayedFilters || emptyObject;
    var debouncedSetFilters = lodashDebounce(function (filter, displayedFilters) {
        changeParams({
            type: SET_FILTER,
            payload: {
                filter: removeEmpty(filter),
                displayedFilters: displayedFilters,
            },
        });
    }, debounce);
    var setFilters = useCallback(function (filter, displayedFilters, debounce) {
        if (displayedFilters === void 0) { displayedFilters = undefined; }
        if (debounce === void 0) { debounce = false; }
        return debounce
            ? debouncedSetFilters(filter, displayedFilters)
            : changeParams({
                type: SET_FILTER,
                payload: {
                    filter: removeEmpty(filter),
                    displayedFilters: displayedFilters,
                },
            });
    }, [changeParams] // eslint-disable-line react-hooks/exhaustive-deps
    );
    var hideFilter = useCallback(function (filterName) {
        changeParams({
            type: HIDE_FILTER,
            payload: filterName,
        });
    }, [changeParams]);
    var showFilter = useCallback(function (filterName, defaultValue) {
        changeParams({
            type: SHOW_FILTER,
            payload: {
                filterName: filterName,
                defaultValue: defaultValue,
            },
        });
    }, [changeParams]);
    return [
        __assign(__assign({ filterValues: filterValues, requestSignature: requestSignature }, query), { displayedFilters: displayedFilterValues }),
        {
            changeParams: changeParams,
            setPage: setPage,
            setPerPage: setPerPage,
            setSort: setSort,
            setFilters: setFilters,
            hideFilter: hideFilter,
            showFilter: showFilter,
        },
    ];
};
var parseObject = function (query, field) {
    if (query[field] && typeof query[field] === 'string') {
        try {
            query[field] = JSON.parse(query[field]);
        }
        catch (err) {
            delete query[field];
        }
    }
};
export var parseQueryFromLocation = function (_a) {
    var search = _a.search;
    var query = parse(search);
    parseObject(query, 'filter');
    parseObject(query, 'displayedFilters');
    return query;
};
/**
 * Check if user has already set custom sort, page, or filters for this list
 *
 * User params come from the store as the params props. By default,
 * this object is:
 *
 * { filter: {}, order: null, page: 1, perPage: null, sort: null }
 *
 * To check if the user has custom params, we must compare the params
 * to these initial values.
 *
 * @param {Object} params
 */
export var hasCustomParams = function (params) {
    return (params &&
        params.filter &&
        (Object.keys(params.filter).length > 0 ||
            params.order != null ||
            params.page !== 1 ||
            params.perPage != null ||
            params.sort != null));
};
/**
 * Merge list params from 3 different sources:
 *   - the query string
 *   - the params stored in the state (from previous navigation)
 *   - the props passed to the List component (including the filter defaultValues)
 */
export var getQuery = function (_a) {
    var queryFromLocation = _a.queryFromLocation, params = _a.params, filterDefaultValues = _a.filterDefaultValues, sort = _a.sort, perPage = _a.perPage;
    var query = Object.keys(queryFromLocation).length > 0
        ? queryFromLocation
        : hasCustomParams(params)
            ? __assign({}, params) : { filter: filterDefaultValues || {} };
    if (!query.sort) {
        query.sort = sort.field;
        query.order = sort.order;
    }
    if (query.perPage == null) {
        query.perPage = perPage;
    }
    if (query.page == null) {
        query.page = 1;
    }
    return __assign(__assign({}, query), { page: getNumberOrDefault(query.page, 1), perPage: getNumberOrDefault(query.perPage, 10) });
};
export var getNumberOrDefault = function (possibleNumber, defaultValue) {
    if (typeof possibleNumber === 'undefined') {
        return defaultValue;
    }
    var parsedNumber = typeof possibleNumber === 'string'
        ? parseInt(possibleNumber, 10)
        : possibleNumber;
    return isNaN(parsedNumber) ? defaultValue : parsedNumber;
};
var emptyObject = {};
var defaultSort = {
    field: 'id',
    order: SORT_ASC,
};
var defaultParams = {};
//# sourceMappingURL=useListParams.js.map