import * as React from 'react';
import { RecordContextProvider } from './RecordContext';
/**
 * Wrap children with a RecordContext provider only if the value is defined.
 *
 * Allows a component to work outside of a record context.
 *
 * @example
 *
 * import { OptionalRecordContextProvider, TextField } from 'react-admin';
 *
 * const RecordTitle = ({ record }) => (
 *     <OptionalRecordContextProvider value={record}>
 *         <TextField source="title" />
 *     </OptionalRecordContextProvider>
 * );
 */
export var OptionalRecordContextProvider = function (_a) {
    var value = _a.value, children = _a.children;
    return value ? (React.createElement(RecordContextProvider, { value: value }, children)) : (children);
};
//# sourceMappingURL=OptionalRecordContextProvider.js.map