import * as React from 'react';
import { useGetRecordRepresentation, useResourceContext } from '../../core';
import { useRecordContext } from './useRecordContext';
/**
 * Render the record representation as specified on its parent <Resource>.
 * @param props The component props
 * @param {string} props.resource The resource name
 * @param {RaRecord} props.record The record to render
 */
export var RecordRepresentation = function (props) {
    var record = useRecordContext(props);
    var resource = useResourceContext(props);
    var getRecordRepresentation = useGetRecordRepresentation(resource);
    return React.createElement(React.Fragment, null, getRecordRepresentation(record));
};
//# sourceMappingURL=RecordRepresentation.js.map