import { useContext } from 'react';
import { ShowContext } from './ShowContext';
/**
 * Hook to read the show controller props from the ShowContext.
 *
 * Used within a <ShowContextProvider> (e.g. as a descendent of <Show>).
 *
 * @returns {ShowControllerResult} create controller props
 *
 * @see useShowController for how it is filled
 */
export var useShowContext = function () {
    var context = useContext(ShowContext);
    // Props take precedence over the context
    if (!context) {
        throw new Error('useShowContext must be used inside a ShowContextProvider');
    }
    return context;
};
//# sourceMappingURL=useShowContext.js.map