import * as React from 'react';
import { useMemo } from 'react';
import { QueryClientProvider, QueryClient } from '@tanstack/react-query';
import { AdminRouter } from '../routing';
import { AuthContext, convertLegacyAuthProvider } from '../auth';
import { DataProviderContext, convertLegacyDataProvider, defaultDataProvider, } from '../dataProvider';
import { StoreContextProvider, memoryStore } from '../store';
import { PreferencesEditorContextProvider } from '../preferences/PreferencesEditorContextProvider';
import { I18nContextProvider } from '../i18n';
import { ResourceDefinitionContextProvider } from './ResourceDefinitionContext';
import { NotificationContextProvider } from '../notification';
var defaultStore = memoryStore();
export var CoreAdminContext = function (props) {
    var authProvider = props.authProvider, basename = props.basename, _a = props.dataProvider, dataProvider = _a === void 0 ? defaultDataProvider : _a, i18nProvider = props.i18nProvider, _b = props.store, store = _b === void 0 ? defaultStore : _b, children = props.children, queryClient = props.queryClient;
    if (!dataProvider) {
        throw new Error("Missing dataProvider prop.\nReact-admin requires a valid dataProvider function to work.");
    }
    var finalQueryClient = useMemo(function () { return queryClient || new QueryClient(); }, [queryClient]);
    var finalAuthProvider = useMemo(function () {
        return authProvider instanceof Function
            ? convertLegacyAuthProvider(authProvider)
            : authProvider;
    }, [authProvider]);
    var finalDataProvider = useMemo(function () {
        return dataProvider instanceof Function
            ? convertLegacyDataProvider(dataProvider)
            : dataProvider;
    }, [dataProvider]);
    return (React.createElement(AuthContext.Provider, { value: finalAuthProvider },
        React.createElement(DataProviderContext.Provider, { value: finalDataProvider },
            React.createElement(StoreContextProvider, { value: store },
                React.createElement(PreferencesEditorContextProvider, null,
                    React.createElement(QueryClientProvider, { client: finalQueryClient },
                        React.createElement(AdminRouter, { basename: basename },
                            React.createElement(I18nContextProvider, { value: i18nProvider },
                                React.createElement(NotificationContextProvider, null,
                                    React.createElement(ResourceDefinitionContextProvider, null, children))))))))));
};
//# sourceMappingURL=CoreAdminContext.js.map