import * as React from 'react';
import { Children } from 'react';
import { Route, Routes } from 'react-router-dom';
import { WithPermissions, LogoutOnMount, useAuthState } from '../auth';
import { useScrollToTop } from '../routing';
import { useConfigureAdminRouterFromChildren } from './useConfigureAdminRouterFromChildren';
import { HasDashboardContextProvider } from './HasDashboardContext';
import { NavigateToFirstResource } from './NavigateToFirstResource';
export var CoreAdminRoutes = function (props) {
    useScrollToTop();
    var _a = useConfigureAdminRouterFromChildren(props.children), customRoutesWithLayout = _a.customRoutesWithLayout, customRoutesWithoutLayout = _a.customRoutesWithoutLayout, status = _a.status, resources = _a.resources;
    var Layout = props.layout, CatchAll = props.catchAll, dashboard = props.dashboard, LoadingPage = props.loading, requireAuth = props.requireAuth, Ready = props.ready, _b = props.authenticationError, AuthenticationError = _b === void 0 ? Noop : _b, _c = props.accessDenied, AccessDenied = _c === void 0 ? Noop : _c;
    var _d = useAuthState(undefined, 
    // do not log the user out on failure to allow access to custom routes with no layout
    false, { enabled: requireAuth }), authenticated = _d.authenticated, isPendingAuthenticated = _d.isPending;
    if (status === 'empty') {
        if (!Ready) {
            throw new Error('The admin is empty. Please provide an empty component, or pass Resource or CustomRoutes as children.');
        }
        return React.createElement(Ready, null);
    }
    // Note: custom routes with no layout are always rendered, regardless of the auth status
    if (status === 'loading' || (requireAuth && isPendingAuthenticated)) {
        return (React.createElement(Routes, null,
            customRoutesWithoutLayout,
            React.createElement(Route, { path: "*", element: React.createElement("div", { style: { height: '100vh' } },
                    React.createElement(LoadingPage, null)) })));
    }
    if (requireAuth && (isPendingAuthenticated || !authenticated)) {
        return (React.createElement(Routes, null,
            customRoutesWithoutLayout,
            React.createElement(Route, { path: "*", element: React.createElement(LogoutOnMount, null) })));
    }
    return (React.createElement(Routes, null,
        customRoutesWithoutLayout,
        React.createElement(Route, { path: "/*", element: React.createElement(HasDashboardContextProvider, { value: !!dashboard },
                React.createElement(Layout, null,
                    React.createElement(Routes, null,
                        customRoutesWithLayout,
                        Children.map(resources, function (resource) { return (React.createElement(Route, { key: resource.props.name, path: "".concat(resource.props.name, "/*"), element: resource })); }),
                        React.createElement(Route, { path: "/", element: dashboard ? (React.createElement(WithPermissions, { authParams: defaultAuthParams, component: dashboard, loading: LoadingPage })) : (React.createElement(NavigateToFirstResource, { loading: LoadingPage })) }),
                        React.createElement(Route, { path: "/authentication-error", element: React.createElement(AuthenticationError, null) }),
                        React.createElement(Route, { path: "/access-denied", element: React.createElement(AccessDenied, null) }),
                        React.createElement(Route, { path: "*", element: React.createElement(CatchAll, null) })))) })));
};
// FIXME in v6: make dashboard anonymous by default to remove this hack
var defaultAuthParams = { params: { route: 'dashboard' } };
var Noop = function () { return null; };
//# sourceMappingURL=CoreAdminRoutes.js.map