import * as React from 'react';
import { useEffect, isValidElement, createElement, useState, } from 'react';
import { Routes, Route } from 'react-router-dom';
import { ErrorBoundary } from 'react-error-boundary';
import { CoreAdminRoutes } from './CoreAdminRoutes';
import { useResetErrorBoundaryOnLocationChange } from '../routing';
import { Ready } from '../util';
import { DefaultTitleContextProvider } from './DefaultTitleContext';
var DefaultLayout = function (_a) {
    var children = _a.children;
    return (React.createElement(React.Fragment, null, children));
};
var DefaultError = function (_a) {
    var error = _a.error, errorInfo = _a.errorInfo, resetErrorBoundary = _a.resetErrorBoundary;
    useResetErrorBoundaryOnLocationChange(resetErrorBoundary);
    return (React.createElement("div", null,
        React.createElement("h1", null, "Error"),
        React.createElement("pre", null,
            error.message, errorInfo === null || errorInfo === void 0 ? void 0 :
            errorInfo.componentStack)));
};
export var CoreAdminUI = function (props) {
    var _a = useState({}), errorInfo = _a[0], setErrorInfo = _a[1];
    var _b = props.authCallbackPage, LoginCallbackPage = _b === void 0 ? false : _b, _c = props.catchAll, catchAll = _c === void 0 ? Noop : _c, children = props.children, dashboard = props.dashboard, _d = props.disableTelemetry, disableTelemetry = _d === void 0 ? false : _d, _e = props.error, ErrorComponent = _e === void 0 ? DefaultError : _e, _f = props.layout, layout = _f === void 0 ? DefaultLayout : _f, _g = props.loading, loading = _g === void 0 ? Noop : _g, _h = props.loginPage, LoginPage = _h === void 0 ? false : _h, _j = props.ready, ready = _j === void 0 ? Ready : _j, _k = props.requireAuth, requireAuth = _k === void 0 ? false : _k, _l = props.title, title = _l === void 0 ? 'React Admin' : _l, _m = props.authenticationError, authenticationError = _m === void 0 ? Noop : _m, _o = props.accessDenied, accessDenied = _o === void 0 ? Noop : _o;
    useEffect(function () {
        if (disableTelemetry ||
            process.env.NODE_ENV !== 'production' ||
            typeof window === 'undefined' ||
            typeof window.location === 'undefined' ||
            typeof Image === 'undefined') {
            return;
        }
        var img = new Image();
        img.src = "https://react-admin-telemetry.marmelab.com/react-admin-telemetry?domain=".concat(window.location.hostname);
    }, [disableTelemetry]);
    var handleError = function (error, info) { return setErrorInfo(info); };
    return (React.createElement(DefaultTitleContextProvider, { value: title },
        React.createElement(ErrorBoundary, { onError: handleError, fallbackRender: function (_a) {
                var error = _a.error, resetErrorBoundary = _a.resetErrorBoundary;
                return (React.createElement("div", { style: { minHeight: '100vh' } },
                    React.createElement(ErrorComponent, { error: error, errorInfo: errorInfo, resetErrorBoundary: resetErrorBoundary })));
            } },
            React.createElement(Routes, null,
                LoginPage !== false && LoginPage !== true ? (React.createElement(Route, { path: "/login", element: createOrGetElement(LoginPage) })) : null,
                LoginCallbackPage !== false &&
                    LoginCallbackPage !== true ? (React.createElement(Route, { path: "/auth-callback", element: createOrGetElement(LoginCallbackPage) })) : null,
                React.createElement(Route, { path: "/*", element: React.createElement(CoreAdminRoutes, { catchAll: catchAll, dashboard: dashboard, layout: layout, loading: loading, requireAuth: requireAuth, ready: ready, authenticationError: authenticationError, accessDenied: accessDenied }, children) })))));
};
var createOrGetElement = function (el) { return (isValidElement(el) ? el : createElement(el)); };
var Noop = function () { return null; };
//# sourceMappingURL=CoreAdminUI.js.map