import * as React from 'react';
import { Navigate } from 'react-router';
import { useFirstResourceWithListAccess } from './useFirstResourceWithListAccess';
import { useCreatePath } from '../routing';
/**
 * This component will inspect the registered resources and navigate to the first one for which users have access to the list page.
 * @param props
 * @param props.loading The component to display while the component is loading.
 */
export var NavigateToFirstResource = function (_a) {
    var LoadingPage = _a.loading;
    var _b = useFirstResourceWithListAccess(), resource = _b.resource, isPending = _b.isPending;
    var createPath = useCreatePath();
    if (isPending) {
        return React.createElement(LoadingPage, null);
    }
    if (resource) {
        return (React.createElement(Navigate, { to: createPath({
                resource: resource,
                type: 'list',
            }), replace: true }));
    }
};
//# sourceMappingURL=NavigateToFirstResource.js.map