import * as React from 'react';
import { ResourceContextProvider } from './ResourceContextProvider';
/**
 * Wrap children with a ResourceContext provider only if the value is defined.
 *
 * Allows a component to work outside of a resource context.
 *
 * @example
 *
 * import { OptionalResourceContextProvider, EditButton } from 'react-admin';
 *
 * const Button = ({ resource }) => (
 *     <OptionalResourceContextProvider value={resource}>
 *         <EditButton />
 *     </OptionalResourceContextProvider>
 * );
 */
export var OptionalResourceContextProvider = function (_a) {
    var value = _a.value, children = _a.children;
    return value ? (React.createElement(ResourceContextProvider, { value: value }, children)) : (children);
};
//# sourceMappingURL=OptionalResourceContextProvider.js.map