import * as React from 'react';
import { AdminChildren, ResourceDefinition, ResourceOptions } from '../types';
export type ResourceDefinitions<OptionsType extends ResourceOptions = any> = {
    [name: string]: ResourceDefinition<OptionsType>;
};
export type ResourceDefinitionContextValue = {
    definitions: ResourceDefinitions;
    register: (config: ResourceDefinition) => void;
    unregister: (config: ResourceDefinition) => void;
};
export declare const ResourceDefinitionContext: React.Context<ResourceDefinitionContextValue>;
/**
 * Context to store the current resource Definition.
 *
 * Use the useResourceDefinition() hook to read the context.
 *
 * @example
 *
 * import { useResourceDefinition, useTranslate } from 'ra-core';
 *
 * const PostMenuItem = () => {
 *     const { name, icon } = useResourceDefinition({ resource: 'posts' });
 *
 *     return (
 *          <MenuItem>
 *              <ListItemIcon>{icon}</ListItemIcon>
 *              {name}
 *          </MenuItem>
 *     );
 * };
 */
export declare const ResourceDefinitionContextProvider: ({ definitions: defaultDefinitions, children, }: {
    definitions?: ResourceDefinitions<any> | undefined;
    children: AdminChildren;
}) => React.JSX.Element;
//# sourceMappingURL=ResourceDefinitionContext.d.ts.map