var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { createContext, useCallback, useState, useMemo } from 'react';
import isEqual from 'lodash/isEqual';
export var ResourceDefinitionContext = createContext({
    definitions: {},
    register: function () { },
    unregister: function () { },
});
/**
 * Context to store the current resource Definition.
 *
 * Use the useResourceDefinition() hook to read the context.
 *
 * @example
 *
 * import { useResourceDefinition, useTranslate } from 'ra-core';
 *
 * const PostMenuItem = () => {
 *     const { name, icon } = useResourceDefinition({ resource: 'posts' });
 *
 *     return (
 *          <MenuItem>
 *              <ListItemIcon>{icon}</ListItemIcon>
 *              {name}
 *          </MenuItem>
 *     );
 * };
 */
export var ResourceDefinitionContextProvider = function (_a) {
    var _b = _a.definitions, defaultDefinitions = _b === void 0 ? {} : _b, children = _a.children;
    var _c = useState(defaultDefinitions), definitions = _c[0], setState = _c[1];
    var register = useCallback(function (config) {
        setState(function (prev) {
            var _a;
            return isEqual(prev[config.name], config)
                ? prev
                : __assign(__assign({}, prev), (_a = {}, _a[config.name] = config, _a));
        });
    }, []);
    var unregister = useCallback(function (config) {
        setState(function (prev) {
            var _a = prev, _b = config.name, _ = _a[_b], rest = __rest(_a, [typeof _b === "symbol" ? _b : _b + ""]);
            return rest;
        });
    }, []);
    var contextValue = useMemo(function () { return ({ definitions: definitions, register: register, unregister: unregister }); }, [definitions] // eslint-disable-line react-hooks/exhaustive-deps
    );
    return (React.createElement(ResourceDefinitionContext.Provider, { value: contextValue }, children));
};
//# sourceMappingURL=ResourceDefinitionContext.js.map