import { createContext, useContext } from 'react';
/**
 * Context that provides a function that accept a source and return getters for the modified source and label.
 *
 * This allows some special inputs to prefix or suffix the source of their children.
 *
 * @example
 * const sourceContext = {
 *  getSource: source => `coordinates.${source}`,
 *  getLabel: source => `resources.posts.fields.${source}`,
 * }
 * const CoordinatesInput = () => {
 *   return (
 *     <SourceContextProvider value={sourceContext}>
 *       <TextInput source="lat" />
 *       <TextInput source="lng" />
 *     </SourceContextProvider>
 *   );
 * };
 */
export var SourceContext = createContext(undefined);
var defaultContextValue = {
    getSource: function (source) { return source; },
    getLabel: function (source) { return source; },
};
export var SourceContextProvider = SourceContext.Provider;
export var useSourceContext = function () {
    var context = useContext(SourceContext);
    if (!context) {
        return defaultContextValue;
    }
    return context;
};
export var useOptionalSourceContext = function () { return useContext(SourceContext); };
//# sourceMappingURL=SourceContext.js.map