import { useCanAccessResources } from '../auth/useCanAccessResources';
import { useAuthenticated } from '../auth';
import { useResourceDefinitions } from './useResourceDefinitions';
/**
 * A hook that returns the first resource for which users have access to the list page.
 * It calls the `authProvider.canAccess` if available to check the permissions.
 */
export var useFirstResourceWithListAccess = function () {
    var isPendingAuthenticated = useAuthenticated().isPending;
    var resources = useResourceDefinitions();
    var resourcesNames = Object.keys(resources).filter(function (resource) { return resources[resource].hasList; });
    var _a = useCanAccessResources({
        action: 'list',
        resources: resourcesNames,
        enabled: !isPendingAuthenticated,
    }), canAccess = _a.canAccess, isPending = _a.isPending;
    var firstResourceWithListAccess = resourcesNames.find(function (resource) { return canAccess && canAccess[resource] === true; });
    return { resource: firstResourceWithListAccess, isPending: isPending };
};
//# sourceMappingURL=useFirstResourceWithListAccess.js.map