import * as React from 'react';
import { useCallback } from 'react';
import get from 'lodash/get';
import { useResourceDefinition } from './useResourceDefinition';
/**
 * Get default string representation of a record
 *
 * @example // No customization
 * const getRecordRepresentation = useGetRecordRepresentation('posts');
 * getRecordRepresentation({ id: 1, title: 'Hello' }); // => "#1"
 *
 * @example // With <Resource name="posts" recordRepresentation="title" />
 * const getRecordRepresentation = useGetRecordRepresentation('posts');
 * getRecordRepresentation({ id: 1, title: 'Hello' }); // => "Hello"
 */
export var useGetRecordRepresentation = function (resource) {
    var recordRepresentation = useResourceDefinition({ resource: resource }).recordRepresentation;
    return useCallback(function (record) {
        if (!record)
            return '';
        if (typeof recordRepresentation === 'function') {
            return recordRepresentation(record);
        }
        if (typeof recordRepresentation === 'string') {
            return get(record, recordRepresentation);
        }
        if (React.isValidElement(recordRepresentation)) {
            return recordRepresentation;
        }
        if ((record === null || record === void 0 ? void 0 : record.name) != null && (record === null || record === void 0 ? void 0 : record.name) !== '') {
            return record.name;
        }
        if ((record === null || record === void 0 ? void 0 : record.title) != null && (record === null || record === void 0 ? void 0 : record.title) !== '') {
            return record.title;
        }
        if ((record === null || record === void 0 ? void 0 : record.label) != null && (record === null || record === void 0 ? void 0 : record.label) !== '') {
            return record.label;
        }
        if ((record === null || record === void 0 ? void 0 : record.reference) != null && (record === null || record === void 0 ? void 0 : record.reference) !== '') {
            return record.reference;
        }
        return "#".concat(record.id);
    }, [recordRepresentation]);
};
//# sourceMappingURL=useGetRecordRepresentation.js.map